"use client"

import { DialogContent, DialogDescription, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import { ComponentWithClassName } from "@/types/utils";
import { TransformedStatewideService } from "../type/transformers";
import { InputCopy } from "@/components/ui/input.copy";
import { InputCopyArea } from "@/components/ui/input.copy-area";

export function WorkflowDialogView({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedStatewideService> }>) {
  return (
    <DialogContent className={className}>
      <DialogHeader>
        <DialogTitle>Service details</DialogTitle>
        <DialogDescription>Currently viewing details about &apos;<span className="font-mono">{data.alias}</span>&apos;.</DialogDescription>
      </DialogHeader>

      <InputCopy defaultValue={data.agencyId} label={"Agency identifier"} />

      <InputCopy defaultValue={data.alias} label={"Service name"} />

      <InputCopy defaultValue={data.url} label={"Website"} />

      <InputCopy defaultValue={data.phone} label={"Phone number"} />

      <InputCopyArea defaultValue={data.message} label={"Message"} />
    </DialogContent>
  )
}

